<?php
// Initialize the session
require_once('./services/database.php');

session_start();

function checkAuth($email, $password) {
    // Get instance of the database service
    $dbService = DatabaseService::getInstance();

    // Check if user exists and password is correct
    $user = $dbService->getUserByEmail($email);
    
    if ($user && password_verify($password, $user['password_hash'])) {
        // Set session variables based on the user's details
        setSession($user['user_id'], $user['email'], $user['role']);
        return true;
    } else {
        return false;
    }
}

function setSession($userId, $email, $role) {
    // You can store more information as needed
    $_SESSION["user_id"] = $userId;
    $_SESSION["email"] = $email;
    $_SESSION["role"] = $role;
    $_SESSION["loggedin"] = true; // You can check this to confirm the user is logged in
}

function logoutSession() {
    // Unset all of the session variables
    $_SESSION = array();

    // Destroy the session.
    session_destroy();
}


